/**
 * COMPATIBLE READERS: ALL READER PROVIDED WITH BLE CONNECTION.
 *
 *   ******  PLEASE, ENSURE THAT READERS like skID are configured in BLE and Bluetooth and
 *           Localization system service are enabled on your Android device BEFORE TESTING
 *           WITH THIS APP (see relatives User/tech manuals for further information)    ******
 *
 * THIS EXAMPLE SHOW A SIMPLE APP THAT FIND THE FIRST BLE CAEN RFID DEVICE, TAKE PERMISSION TO
 * COMMUNICATE WITH, AND WAIT FOR INVENTORY. FOR DEMO PURPOSE, THIS APP DOESN'T MANAGE PERMISSION
 * DENIALS, OR DETAILED EXCEPTION HANDLING.
 *
 * THE FLOATING ACTION BUTTON DOES THE FOLLOWING:
 *
 *  1) CONNECT TO THE READER using BLE
 *  2) REGISTER EVENT READING  CALLBACK
 *  3) WAIT 3 SECONDS FOR ANY PREVIOUS READING EVENTS.
 *  4) SET POWER TO 50 mW
 *  5) PREPARE CONTINUOUS READING.
 *  6) LAUNCH CONTINUOUS READING.
 *  7) WAITS FOR CONFIGURED SECONDS TO STOP READER.
 *   ... in the meanwhile if any tag is found, then the API will raise the callback...
 *  8) STOP THE CONTINUOUS READING.
 *  9) UNREGISTER THE CALLBACK
 *  10) DISCONNECT FROM BLE READER.
 */

package com.example.caenrfidsampleapp;

import android.Manifest;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;

import com.caen.BLEPort.BLEPort;
import com.caen.BLEPort.CAENRFIDBleScannerCallBacks;
import com.caen.RFIDLibrary.CAENRFIDEventListener;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDNotify;
import com.caen.RFIDLibrary.CAENRFIDReader;
import com.caen.RFIDLibrary.CAENRFIDReaderInfo;
import com.example.caenrfidsampleapp.databinding.ActivityMainBinding;
import com.google.android.material.snackbar.Snackbar;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MainActivity extends AppCompatActivity {

    static final int INVENTORY_DURATION = 2;

    // Utiliy function to print hex string.
    static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    static String bytesToHex(byte[] bytes) {
        if (bytes == null)
            return "NULL";
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; j++) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0x0F];
        }
        return new String(hexChars);
    }


    AppBarConfiguration appBarConfiguration;

    ActivityMainBinding binding;

    TextView outputText;

    // The CAEN RFID ble object that represents the device.
    BluetoothDevice bluetoothDevice;

    List<BluetoothDevice> devices;

    final AtomicBoolean isDiscoveringActivated = new AtomicBoolean(Boolean.FALSE);

    //CAEN RFID API Callback for EventInventoryTag: it will print the ID part of the EPC of the tag.
    CAENRFIDEventListener caenrfidEventListener = evt -> {
        CAENRFIDNotify tag = evt.getData().get(0);
        runOnUiThread(() -> {
            outputText.append("\n" + bytesToHex(tag.getTagID()));
        });
    };

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           @NonNull String[] permissions,
                                           @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        for (int grantResult :
                grantResults) {
            if (grantResult != PackageManager.PERMISSION_GRANTED) {
                Toast.makeText(getApplicationContext(), "permissions rejected", Toast.LENGTH_SHORT).show();
                finish();
            }
        }
        long SEARCH_TIMEOUT = 5000;
        // Finding BLE devices.
        BLEPort.findCAENRFIDBLEDevices(SEARCH_TIMEOUT, new CAENRFIDBleScannerCallBacks() {
            @Override
            public void onStartScan() {
                isDiscoveringActivated.set(true);
                Toast.makeText(getApplicationContext(), " Searching BLE devices", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onStopScan() {
                isDiscoveringActivated.set(false);
                Toast.makeText(getApplicationContext(), "Stop searching BLE devices", Toast.LENGTH_SHORT).show();
                binding.fab.setEnabled(true);
            }

            @Override
            public void onDeviceFound(BluetoothDevice bluetoothDevice) {
                devices.add(bluetoothDevice);
            }
        });
    }

    @SuppressLint("MissingPermission")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        setSupportActionBar(binding.toolbar);

        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_main);
        appBarConfiguration = new AppBarConfiguration.Builder(navController.getGraph()).build();
        NavigationUI.setupActionBarWithNavController(this, navController, appBarConfiguration);

        binding.fab.setOnClickListener(view -> {
            CAENRFIDReader reader = new CAENRFIDReader();

            // To avoid UI freezes, awaits ten seconds and then stop inventory using a separated
            // Thread. In the meanwhile, any tag identified by the reader will be reported to the
            // caenrfidEventListener callback along side the sub command results.
            binding.fab.setEnabled(false);
            new Thread(() -> {
                try {

                    try {
                        // 1) Connection, setup callback and set lower power: devices[0] is a Bluetooth
                        // device received by a previous BT scan operation.
                        if (devices.isEmpty()) {
                            runOnUiThread(()-> Toast.makeText(getApplicationContext(), "NO devices found", Toast.LENGTH_SHORT).show());
                            return;
                        } else {
                            // Here we assign the first BLE device found, but developer can search
                            // in devices for the one he want to connect to.
                            bluetoothDevice = devices.get(0);
                        }
                        reader.Connect(getApplicationContext(), bluetoothDevice);
                        int pow = reader.GetBatteryLevel();
                        runOnUiThread(() -> outputText.append(outputText.getText() + "\nConducted Power is : " + pow + "\n"));
                        // If a previous EventInventoryTag has been called and reader disconnected
                        // suddenly, then stop the reading. Waiting for data streaming end within 3 s
                        // seconds.
                        boolean endOfStreamFound = reader.ForceAbort(3000);
                        if(endOfStreamFound) {
                            // reader was streaming and therefore in continuous mode.
                        } else {
                            // reader has been not found in continuous mode or maybe timeout is too
                            // short. Typically 2 or 3 seconds is enough to waits the end of
                            // streaming, but it strongly depends on the overall  parameter
                            // settings used during for the inventory reader and the number of
                            // discoverable tags.
                        }
                        //Set 50 mW of conducted power.
                        reader.SetPower(50);
                        //Get reader Info
                        CAENRFIDReaderInfo info = reader.GetReaderInfo();
                        runOnUiThread(() -> outputText.setText(String.format("%s %s\n", info.GetModel(), info.GetSerialNumber())));
                        Thread.sleep(1000);
                        // 2) Prepare and launch EventInventoryTag (continuous inventory).
                        reader.addCAENRFIDEventListener(caenrfidEventListener);
                        reader.GetSource("Source_0").SetReadCycle(0);
                        short flag = (short) (CAENRFIDLogicalSource.InventoryFlag.FRAMED.getValue() + CAENRFIDLogicalSource.InventoryFlag.CONTINUOS.getValue());
                        runOnUiThread(() -> {
                            Toast.makeText(getApplicationContext(), "Inventory start on " + bluetoothDevice.getName(), Toast.LENGTH_SHORT).show();
                        });
                        reader.GetSource("Source_0").EventInventoryTag(new byte[]{},(short)0,(short)0, flag);

                        // This thread waits for INVENTORY_DURATION seconds and in the meanwhile,
                        // the API will raise an event (CAENRFIDEventListener) for each tag found.
                        Thread.sleep(INVENTORY_DURATION * 1000L);

                        // Finish EventInventoryTag, try Disconnect and remove event callback.
                        reader.InventoryAbort();
                        reader.Disconnect();
                        reader.removeCAENRFIDEventListener(caenrfidEventListener);
                        runOnUiThread(()->{
                            Toast.makeText(getApplicationContext(),"Inventory stopped", Toast.LENGTH_SHORT).show();
                        });
                    } catch (CAENRFIDException e) {
                        //In case of API exception, ensure to remove callback and try to
                        // disconnect again.
                        try {
                            reader.Disconnect();
                        } catch (CAENRFIDException ignored) {}
                        reader.removeCAENRFIDEventListener(caenrfidEventListener);
                    }
                    runOnUiThread(()->Toast.makeText(getApplicationContext(),"Inventory Stop.", Toast.LENGTH_SHORT).show());
                    runOnUiThread(() -> binding.fab.setEnabled(true));
                } catch (InterruptedException ignored) {}
            }).start();
        });

        devices = new ArrayList<>();
    }

    // On App Start requests bluetooth and location permissions (needed for BLE).
    @Override
    protected void onStart() {
        super.onStart();
        if(Build.VERSION.SDK_INT >=  Build.VERSION_CODES.S) {
            ActivityCompat.requestPermissions(MainActivity.this, new String[]{
                    Manifest.permission.BLUETOOTH_SCAN,
                    Manifest.permission.BLUETOOTH_CONNECT,
                    Manifest.permission.ACCESS_COARSE_LOCATION,
                    Manifest.permission.ACCESS_FINE_LOCATION,
                    Manifest.permission.BLUETOOTH}, 1);
        }else {
            ActivityCompat.requestPermissions(MainActivity.this, new String[]{
                    Manifest.permission.ACCESS_FINE_LOCATION,
                    Manifest.permission.ACCESS_COARSE_LOCATION,
                    Manifest.permission.BLUETOOTH}, 1);
        }
        outputText = getSupportFragmentManager().getFragments().get(0).getView().findViewById(R.id.textview_first);
        binding.fab.setEnabled(false);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onSupportNavigateUp() {
        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_main);
        return NavigationUI.navigateUp(navController, appBarConfiguration)
                || super.onSupportNavigateUp();
    }
}